<?php
/* 	--------	AJAX Domain Availablity Check script (Version 0.992) ------------
[
[ 	Created by "Ganesh" @ http://bootstrike.com/Webdesign/
[	AJAX Domain Availability Check by Bootstrike.Com is licensed under a Creative Commons Attribution 3.0 License.
[	Based on a work at http://www.mattjewell.com/namepros/dnlookup/.
[	Permissions beyond the scope of this license may be available at http://bootstrike.com/PHPAJAXDomainCheck/.
[	DO NOT REDISTRIBUTE THESE FILES. You are only licenced to use this on one domain per licence
*/
/*** ORIGINAL CREDIT SCRIPT ****/
/* 	--------	Bulk domain availablity check script (Revision 4) ------------
[
[ 	Created by "Matthew." (45276) @ http://namepros.com / http://mattjewell.com
[	Feel free to modify/use however you wish,
[	but keep credit comments in upon distribution.
*/
/****************************************************
	C O N F I G U R A B L E    S E T T I N G S
*****************************************************/

/****************************************************
	Allowed Domain TLDs = Set to NULL to allow any domain
	Default:
		$allowedTLDs = null;  // to allow ALL domains
	Examples:
		$allowedTLDs = array('com','net','org');  // to allow only com, net and org domains.
		$allowedTLDs = array('com.sg');  // to allow only com.sg (Singapore) domain checking
****************************************************/
$allowedTLDs = null;  // to allow ALL domains

/****************************************************
	Show 'Available Domains So Far' textarea box
	Examples:
		define ("SHOW_AVAILABLE_DOMAINS",true);   // to show
		define ("SHOW_AVAILABLE_DOMAINS",false);   // to not show
****************************************************/
define ('SHOW_AVAILABLE_DOMAINS',true);


/****************************************************
	Recaptcha prevents automated queries that can crash your server
	If true, shows Recaptcha Dialog Box. ALL settings below are REQUIRED
	==> Register a free account at http://recaptcha.net/ if you don't have the required keys
****************************************************/
define ('ENABLE_RECAPTCHA',false); //set to false to disable, true to enable
define ('RECAPTCHA_PRIVATE_KEY',''); //substitute with private key
define ('RECAPTCHA_PUBLIC_KEY','');  // substitute with pubic key
define ('RECAPTCHA_TOTAL_HITS',10);  // how many checks are allowed per verified captcha. Set to -1 for unlimited

/****************************************************
	Shows the big 'YES' and 'NO' for domains
****************************************************/
define ('SHOW_BIG_STATUS',true); //set to false to disable, true to enable

/****************************************************
	Uncomment line below  to make unlimited script execution time - not recommended for shared hosting
****************************************************/
//set_time_limit(0);

/****************************************************
	Domain Registration Link Template General

	When a domain is available the following template will be used to show the message.
	%DOMAIN% will be substituted with the actual domain name.

	Default:
		define('DOMAIN_REG_LINK','%DOMAIN% is available!');

	Examples:
		define('DOMAIN_REG_LINK','%DOMAIN% is available! <a href="http://mydomain.com/register.php?domain=%DOMAIN%">Lets register it</a>');
		define('DOMAIN_REG_LINK','<a href="http://mydomain.com/register.php?domain=%DOMAIN%">AVAILABLE! Register it now!</a>');
****************************************************/
define('DOMAIN_REG_LINK','%DOMAIN% is available! <b><a href="http://portal.starhostbd.com/cart.php?a=add&domain=register" target="_blank">Register it now!</a></b>');


/****************************************************
	Domain Registration Link Template For Each TLD

	When a domain is available the following template will be used to show the message, for each TLD. If the entry for
	the TLD does not exist, the general one above is used. %DOMAIN% will be substituted with the actual domain name.

	Default (for nothing):
		$domainRegLinkTld = array();

	Example 1 (for .com and .net):
		$domainRegLinkTld = array(
			'com' 		=> '%DOMAIN% is available. <a href="http://mydomain.com/affiliate?domain=%DOMAIN%>Register this .COM now</a>',
			'net' 		=> '%DOMAIN% is available. <a href="http://mydomain2.com/affiliate?domain=%DOMAIN%>Register this .NET now</a>'
		);

	Notes:
	==> LAST ENTRY must NOT end with a comma
	==> DO NOT Begin with a full stop, specify only the TLD (e.g. 'com' and not '.com')
	==> Specify TLDs in LOWER case (e.g. 'com' and not 'COM')
****************************************************/
$domainRegLinkTld = array();

/****************************************************
	Language - change as needed to your own language and the whole script will transform to your language
****************************************************/
$language = array(
	'in_action' 		=> 'AJAX Domain Checker In Action',
	'domain' 			=> 'Domain',
	'available_domains' => 'Available domains so far',
	'no_script_warning' => 'To use this feature, please enable JavaScript and if you are using IE version less than 7, ActiveX.',
	'enter_captcha' 	=> 'Captcha (REQUIRED)',
	'type_a_domain' 	=> 'Type a domain name.',
	'request_sent' 		=> 'Request sent...',
	'retry' 			=> 'Retry',
	'no' 				=> 'NO',
	'yes' 				=> 'NO',
	'Domain_not_Available' 	=> ' is not available.',
	'yes' 				=> 'YES',
	'force_recheck' 	=> 'Force a Recheck',
	'aborted' 			=> 'Aborted',
	'retrying' 			=> 'Retrying...',
	'error_connecting' 	=> 'Error connecting to server ',
	'abort' 			=> 'Abort',
	'checking' 			=> 'Checking... ',
	'invalid_domain' 	=> 'Invalid Domain (Letters, numbers and hypens only)',
	'tld_not_allowed' 	=> 'TLD not allowed. TLDs allowed: ', //appears when an invalid TLD is entered
	'fill_in_Captcha' 	=> 'Please fill in the captcha field above ',
	'enter_tld' 		=> 'Enter the TLD (e.g: .COM)'	,
	'captcha_exceed'	=> 'Exceeded allowable attempts. Please enter a new Captcha',
	'captcha_nomatch'	=> 'Captcha does not match. Please re-enter',
	'do_whois'			=> 'More info', //when clicked, does a WHOIS on the domain name
	'and_press_enter'	=> ' Press Enter when done.',	//shows only when configured to press Enter to start checker
	'unknown_tld'		=> 'Unknown domain extension ' //shows when $enableAutoDomainDetection is set to
														//false and no TLD is found in dnservers
);

/****************************************************
	Other Options
		- $enableAsYouType 				= Set to 'true' to enable checking as-you-type, set to 'false' to activate checking
											ONLY when pressing Enter. 	Default: true
		- $enableReferrerChecking 		= Set to 'true' to check referrers to be from your own domain. Prevents misuse. Set
											to false to disable this check.	Default: true
		- $enableWhoisChecking 			= Set to 'true' to allow visitors to view the WHOIS output for a domain which is not
											available. Default: true
		- $enableGetHostByNameChecking 	= Set to 'true' to allow very fast checking of domain availability by utilizing
											the PHP gethostbyname function. Strongly recommended setting: true
		- $enableCheckDnsRRChecking 	= Set to 'true' to allow very fast checking of domain availability by utilizing
											the PHP checkdnsrr function. Strongly recommended setting: true.
		- $enableWhoisDomainChecking 	= Set to 'false' to skip querying WHOIS servers to really confirm domain is available.
											Slows down query by alot. Recommended: false.
		- $enableAutoDomainDetection 	= Set to 'false' to restrict checks to only those TLDs listed in dnserver. Otherwise it
											will try to detect whois servers for those TLDs that dnservers.php does not have
****************************************************/
$enableAsYouType = false;
$enableReferrerChecking = true;
$enableWhoisChecking = true;
$enableGetHostByNameChecking = true;
$enableCheckDnsRRChecking = true;
$enableWhoisDomainChecking = true;
$enableAutoDomainDetection  = true;

/********************************************************************************
	THAT IS ALL :) If you need more features, let us know at http://bootstrike.com/PHPAJAXDomainCheck/
	Thanks for using our script,
*********************************************************************************/
/****************************************************
	N O N - C O N F I G U R A B L E    S E T T I N G S

	You should not change the below unless you know what you are doing
*****************************************************/
$buffer = '';
//Referrer, Session Checking
$referrerDomain = '';
if ($enableReferrerChecking)
{
	if (session_id() == '')
		session_start();
	if (!isset($_REQUEST['aj']))
		$_SESSION['IS_FROM_SAME_DOMAIN'] = 1;
	if (isset($_SERVER['HTTP_REFERER']))
	{
		//extract referrer domain
		$referrerDomain = $_SERVER['HTTP_REFERER'];
		$referrerDomain = substr($referrerDomain,strpos($referrerDomain,"http://")+7);
		$referrerDomain = substr($referrerDomain,0,strpos($referrerDomain,"/"));
	}
}
require_once('dnservers.php');
$error = '';

//if it is a ajax call, just check and exit - bootstrike
if ((isset($_REQUEST['aj'])) && (isset($_REQUEST['domain'])))
{
	while (ob_get_level()) { ob_end_clean();  }
	$domain = strtolower($_REQUEST['domain']);
	$available = false;
	$message = '';
	$canProceed = true;
	if (($enableReferrerChecking) && (!isset($_SESSION['IS_FROM_SAME_DOMAIN'])))
	{
		$error = 'Please download and install this script on your server. (Session Mismatch)';
		$canProceed = false;
	}
	else if (($enableReferrerChecking) && (!empty($referrerDomain)) && ($referrerDomain != $_SERVER['HTTP_HOST']))
	{
		$error = 'Please download and install this script on your server. (Referrer/host mismatch)';
		$canProceed = false;
	}
	else if (ENABLE_RECAPTCHA)
	{
		if (isset($_SESSION['RECAPTCHA_HITS']) && ($_SESSION['RECAPTCHA_HITS'] < RECAPTCHA_TOTAL_HITS))
		{
			$_SESSION['RECAPTCHA_HITS']++;
			$canProceed = true;
		}
		else if (isset($_SESSION['RECAPTCHA_HITS']) && ($_SESSION['RECAPTCHA_HITS'] == RECAPTCHA_TOTAL_HITS))
		{
			$error = $language['captcha_exceed'];
			$_SESSION['RECAPTCHA_HITS']++;
			$canProceed = false;
		}
		else if (isset($_SESSION['RECAPTCHA_HITS']) && (RECAPTCHA_TOTAL_HITS == -1))
		{
			$_SESSION['RECAPTCHA_HITS']++;
			$canProceed = true;
		}
		else
		{
			require_once('recaptchalib.php');
			$resp = recaptcha_check_answer (RECAPTCHA_PRIVATE_KEY,
											$_SERVER['REMOTE_ADDR'],
											$_GET['rc'],
											$_GET['rr']);
			if (!$resp->is_valid)
			{
				$error = $language['captcha_nomatch'];
				$canProceed = false;
			}
			else
			{
				$canProceed = true;
				$_SESSION['RECAPTCHA_HITS'] = 1;
			}
		}
	}
	if ($canProceed)
	{
		if (($enableWhoisChecking) && (isset($_GET['ws'])))
			$availableArray = isDomainAvailable($domain,true);
		else
			$availableArray = isDomainAvailable($domain);
		if (is_array($availableArray))
		{
			$message = str_replace('%DOMAIN%',$domain,DOMAIN_REG_LINK);
			if ((!empty($domainRegLinkTld))  && (isset($domainRegLinkTld[$availableArray[1][1]])))
			{
				$message = str_replace('%DOMAIN%',$domain,$domainRegLinkTld[$availableArray[1][1]]);
			}
			$available = true;
		}
		else
		{
			if (($enableWhoisChecking) && (isset($_GET['ws'])))
			{
				?>
			<?php
 $pageTitle='Domain Whois Report - StarHOST';
?>
<?php include 'header_assets.php'; ?>
<body>
<div class="main_menu_mobile">
  <?php include 'main_menu.php'; ?>
</div>
<!-- Start Switcher --> 

<!-- End Switcher -->

<?php include 'header.php'; ?>

<!-- Main Menu -->
<div class="main_menu">
  <?php include 'main_menu.php'; ?>
</div>
<!-- End of Main Menu --> 
<section class="section_sapce white">

    <div class="container">
			<?php
				echo '<pre>';
				echo $buffer;
				echo '</pre>';
			?>
		</div>
	</section>
<?php include 'subscribe.php'; ?>

<!--  Footer -->
<footer class="footer">
  <?php include 'footer.php'; ?>
</footer>
<!--  End of Footer --> 

<!--  Scripts --> 
<!--  Back to Top -->
<?php include 'footer_assets.php'; ?>			
			<?php
				exit;
			}
			$available = false;
		}
	}
	if (!empty($error))
		$domain = '(error)';
	header('Content-type: text/xml');
	echo('<?xml version="1.0" ?>');
	?>
    <domaindetails>
      <domainname><?php echo htmlentities($domain); ?></domainname>
      <available><?php echo $available?'true':'false'; ?></available>
      <errorMsg><?php echo htmlentities($error); ?></errorMsg>
      <message><?php echo htmlentities($message); ?></message>
    </domaindetails>
    <?php
	exit;
}

//checks if the passed domain is available, the networking stuff goes on here - bootstrike
//telnet com.whois-servers.net 43 for whoising com server
//any updates here need to reflect in bulk_checker
function isDomainAvailable($R6629C5988EEFCD88EA6F77A2AE672B96,$R9DFAEDF5181E1A426FA8DBE71B349A26=false)  {   global $ext,$error,$allowedTLDs,$language,$buffer,$enableGetHostByNameChecking,$enableCheckDnsRRChecking,$enableWhoisDomainChecking,$enableAutoDomainDetection;   if ($enableWhoisDomainChecking == false) $enableAutoDomainDetection = false;   $R6629C5988EEFCD88EA6F77A2AE672B96 = trim($R6629C5988EEFCD88EA6F77A2AE672B96);   if (preg_match('/^([a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?\.)*[a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?$/i',$R6629C5988EEFCD88EA6F77A2AE672B96) != 1)   {    $error = $language['invalid_domain'].' ('.$R6629C5988EEFCD88EA6F77A2AE672B96.')';    return false;   }   preg_match('@^(http://www\.|http://|www\.)?([^/]+)@i', $R6629C5988EEFCD88EA6F77A2AE672B96, $R2BC3A0F3554F7C295CD3CC4A57492121);   $buffer = '';   $R6629C5988EEFCD88EA6F77A2AE672B96 = $R2BC3A0F3554F7C295CD3CC4A57492121[2];   $R37D331C368B44BDD85AF95D9FFFFD202 = explode('.', $R6629C5988EEFCD88EA6F77A2AE672B96);   $R33D3EC748433467E20D0947C3032E305 = '';   if (count($R37D331C368B44BDD85AF95D9FFFFD202) == 3)   {    $R33D3EC748433467E20D0947C3032E305 = strtolower($R37D331C368B44BDD85AF95D9FFFFD202[1].'.'.$R37D331C368B44BDD85AF95D9FFFFD202[2]);   }   else if (count($R37D331C368B44BDD85AF95D9FFFFD202) == 2)   {    $R33D3EC748433467E20D0947C3032E305 = strtolower($R37D331C368B44BDD85AF95D9FFFFD202[1]);   }   else   {       $error = $language['invalid_domain'];    return false;   }   if ($allowedTLDs != null)   {    $R630663E4CF314AFD500B9B8E1AA95DF0 = count($allowedTLDs);    $RDBF866E6293BB59E654033E299EC8CFE = false;    for ($RA16D2280393CE6A2A5428A4A8D09E354 = 0; $RA16D2280393CE6A2A5428A4A8D09E354 < $R630663E4CF314AFD500B9B8E1AA95DF0; $RA16D2280393CE6A2A5428A4A8D09E354++)    {     if ($allowedTLDs[$RA16D2280393CE6A2A5428A4A8D09E354] === $R33D3EC748433467E20D0947C3032E305)     {      $RDBF866E6293BB59E654033E299EC8CFE = true;      break;     }    }    if (!$RDBF866E6293BB59E654033E299EC8CFE)    {     $error = $R33D3EC748433467E20D0947C3032E305.$language['tld_not_allowed'];     return false;    }   }   $R019FB4DA0E10A95A57615147DF79F334 = false;   if (!array_key_exists('.'.$R33D3EC748433467E20D0947C3032E305, $ext))   {    if ($enableAutoDomainDetection === false)    {     $error = $language['unknown_tld'].$R33D3EC748433467E20D0947C3032E305;     return false;    }    $R019FB4DA0E10A95A57615147DF79F334 = true;   }   if ($R9DFAEDF5181E1A426FA8DBE71B349A26 === false)   {    if ($enableCheckDnsRRChecking)    {     if (function_exists('checkdnsrr'))     {      if (checkdnsrr($R6629C5988EEFCD88EA6F77A2AE672B96) !== false) return false;           if (checkdnsrr($R6629C5988EEFCD88EA6F77A2AE672B96,'A') !== false) return false;     }    }    if ($enableGetHostByNameChecking)    {     $RE22CBD8984E1727D0A587413D72A88CF = gethostbyname ($R6629C5988EEFCD88EA6F77A2AE672B96);     if (($RE22CBD8984E1727D0A587413D72A88CF != $R6629C5988EEFCD88EA6F77A2AE672B96) && ($RE22CBD8984E1727D0A587413D72A88CF != '208.67.219.132'))     {      return false;     }    }    if (!$enableWhoisDomainChecking)    {     return array('true',$R37D331C368B44BDD85AF95D9FFFFD202);    }   }   $server = '';   if (isset($_REQUEST['opendns'])) { echo '208.67.219.13'; exit; }   if ($R019FB4DA0E10A95A57615147DF79F334)   {    $RBD7EDCF7DA1CE9EA93A9B3BBD829FFBB = explode('.',$R33D3EC748433467E20D0947C3032E305);    if (count($RBD7EDCF7DA1CE9EA93A9B3BBD829FFBB) > 1)     $server = $RBD7EDCF7DA1CE9EA93A9B3BBD829FFBB[1].'.whois-servers.net';    else     $server = $R33D3EC748433467E20D0947C3032E305.'.whois-servers.net';    $R7B8A9F2F48B874D40BD75BDD12F02557 = @gethostbyname($R33D3EC748433467E20D0947C3032E305.'.whois-servers.net');   }   else   {    $server = $ext['.' .$R33D3EC748433467E20D0947C3032E305][0];    $R7B8A9F2F48B874D40BD75BDD12F02557 = @gethostbyname($server);   }   if ($R33D3EC748433467E20D0947C3032E305 == 'es')   {    $error = 'Error: ES not supported. They don\'t have a public whois server :(';    return false;   }   if ($R33D3EC748433467E20D0947C3032E305 == 'au')   {    $server = $ext['.com.au'][0];    $R7B8A9F2F48B874D40BD75BDD12F02557 = @gethostbyname($server);   }   if ($R7B8A9F2F48B874D40BD75BDD12F02557 == $server)   {    $error = 'Error: Invalid extension - '.$R33D3EC748433467E20D0947C3032E305.'. Or server has outgoing connections blocked to '.$server.'.  Domain does not have DNS entry, so chances are high it is available.';    return false;   }   $RAD10634E7F72CAA071320F21AEE5930D = @fsockopen($server, 43,$R32D00070D4FFBCCE2FC669BBA812D4C2,$RE5840D3E86DCF8489051E4F70C757552,10);   if ($R32D00070D4FFBCCE2FC669BBA812D4C2 == '10060')   {    $error = 'Error: Invalid extension - '.$R33D3EC748433467E20D0947C3032E305.' (or whois server is down). Domain does not have DNS entry, so chances are high it is available.';    return false;   }   if (!$RAD10634E7F72CAA071320F21AEE5930D || ($RE5840D3E86DCF8489051E4F70C757552 != ''))   {    $error = 'Error: ('.$server.') '.$RE5840D3E86DCF8489051E4F70C757552.' ('.$R32D00070D4FFBCCE2FC669BBA812D4C2.')';    return false;   }   fputs($RAD10634E7F72CAA071320F21AEE5930D, "$R6629C5988EEFCD88EA6F77A2AE672B96\r\n");   while( !feof($RAD10634E7F72CAA071320F21AEE5930D) )   {    $buffer .= fgets($RAD10634E7F72CAA071320F21AEE5930D,128);   }   fclose($RAD10634E7F72CAA071320F21AEE5930D);   if($R33D3EC748433467E20D0947C3032E305 == 'org') nl2br($buffer);     if ($R019FB4DA0E10A95A57615147DF79F334)   {    if ( (strpos($buffer,'No match for') !== false) ||     (strpos($buffer,'NOT Found') !== false) ||     (strpos($buffer,'NOT FOUND') !== false) ||     (strpos($buffer,'Not found: ') !== false) ||     (strpos($buffer,"No Found\n") !== false) ||     (strpos($buffer,'NOMATCH') !== false) ||     (strpos($buffer,"AVAIL\n") !== false) ||     (strpos($buffer,'No entries found') !== false) ||     (strpos($buffer,'NO MATCH') !== false) ||     (strpos($buffer,'No match') !== false) ||     (strpos($buffer,'No such Domain') !== false) ||     (strpos($buffer,'is free') !== false) ||     (strpos($buffer,'FREE') !== false) ||     (strpos($buffer,'No data Found') !== false) ||     (strpos($buffer,'No Data Found') !== false) ||     ($buffer == "Available\n")  ||     (strpos($buffer,'No information about') !== false) ||     (strpos($buffer,'no matching record') !== false) ||     (strpos($buffer,'does not Exist in database') !== false) ||     (strpos($buffer,'Status: AVAILABLE') !== false) ||     (strpos($buffer,'not a registered domain') !== false) )     {      return array('true',$R37D331C368B44BDD85AF95D9FFFFD202);     }    return false;   }   else   {    if ((strpos($R33D3EC748433467E20D0947C3032E305,'.au') > 0) && ($buffer == "Not Available\n"))    {     return false;    }    if(preg_match('/'.$ext['.' . $R33D3EC748433467E20D0947C3032E305][1].'/i', $buffer))    {     return array('true',$R37D331C368B44BDD85AF95D9FFFFD202);    }    else    {     return false;    }   }   return false;  }


$tableColSize = 0;
if (ENABLE_RECAPTCHA)
	$tableColSize++;
if (SHOW_BIG_STATUS)
	$tableColSize++;
if (SHOW_BIG_STATUS)
	$tableColSize++;
?>
<script type="text/javascript">
//Specify the time to wait before checking
var intervalToCheckForChange = 250; // in milliseconds, 300 = 0.3sec
var request;
var	statusDivJS;
var	isAvailableDivJS;
var	domainInput;
var domainsAvailableInput;
var isInProgress = false;
var prevCheckValue = ".com";
var whatDomainDivJS;
var intStartCheck;
var isLoaded = false;
var intFailedResponse;
var timesError = 0;
<?php if ($allowedTLDs != null) { ?>
var allowedTLDs = new Array(<?php
				$totalSize = count($allowedTLDs);
				for ($i = 0; $i < $totalSize; $i++)
				{
					echo '"'.$allowedTLDs[$i].'"';
					if ($i != ($totalSize-1)) echo ',';
				}
				?>	);
<?php } else { ?>
var allowedTLDs = null;
<?php } ?>
var ajaxDomainForm;
var showAvailableDomains = <?php if (SHOW_AVAILABLE_DOMAINS) echo 'true'; else echo 'false'; ?>;
var enableCaptcha = <?php if (ENABLE_RECAPTCHA) echo 'true'; else echo 'false'; ?>;
var recaptcha_text;
function checkDomain()
{
	if (isInProgress) return;
	isInProgress = true;
	prevCheckValue = domainInput.value;
	if (domainInput.value.indexOf(".") < 0)
	{
		statusDivJS.innerHTML = "<span style='color:red;'><?php echo $language['enter_tld'] ?><\/span>";
		isInProgress = false;
		return;
	}
	else if ((enableCaptcha) && ((Recaptcha == null) || ((Recaptcha.get_response() == ''))))
	{
		statusDivJS.innerHTML = "<span style='color:red;'><?php echo $language['fill_in_Captcha'] ?>[ <a href='#' onClick='checkDomain();return false;'><?php echo $language['retry'] ?><\/a> ]<\/span>";
		isInProgress = false;
		return;
	}
	else
	{
		//check whether valid extension
		extension = prevCheckValue.substr(prevCheckValue.indexOf('.')+1);
		if ((extension != '') && (allowedTLDs != null))
		{
			found = false;
			for (i = 0; i < allowedTLDs.length; i++)
			{
				if (allowedTLDs[i] == extension)
				{
					found = true;
					break;
				}
			}
			if (found == false)
			{
				statusDivJS.innerHTML = "<span style='color:red;'><?php echo $language['tld_not_allowed'] ?>"+allowedTLDs+" <\/span>";
				isInProgress = false;
				return;
			}
		}
	}
	re = new RegExp("^([a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?\.)*[a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?$");
	if (prevCheckValue.match(re) == null)
	{
		statusDivJS.innerHTML = "<span style='color:red;'><?php echo $language['invalid_domain'] ?> <\/span>";
		isInProgress = false;
		return;
	}
	statusDivJS.innerHTML = "<span style='color:#00a63f;'><img src='prg.gif' height='16' width='16' alt='in progress'><?php echo $language['checking'] ?> "+prevCheckValue+" [ <a href='#' onClick='abortRequest();return false;'><?php echo $language['abort'] ?><\/a> / <a href='#' onClick='retryRequest();return false;'><?php echo $language['retry'] ?><\/a> ]<\/span>";
	if (window.XMLHttpRequest)
	{ // Mozilla, Safari, ...
		request = new XMLHttpRequest();
	}
	else if (window.ActiveXObject)
	{ // IE
		request = new ActiveXObject("Microsoft.XMLHTTP");
	}
	recap_challenge = '';
	recap_response = '';
	<?php if (ENABLE_RECAPTCHA)
	{ ?>
		recap_challenge = Recaptcha.get_challenge();
		recap_response = Recaptcha.get_response();
		if (recap_challenge == null) return;
		Recaptcha.destroy();
		recaptcha_text.style.display="none";
	<?php
	} ?>
	var requestUrl = "?aj=&ma="+Math.random()+"&domain="+prevCheckValue+"&rc="+recap_challenge+"&rr="+recap_response;
	//document.location.href = requestUrl;return;
	request.open("GET",requestUrl,true);
	request.onreadystatechange = processResponse;
	intFailedResponse = setTimeout("failedResponse()",15000);
	try {request.send(null); }
	catch (e)
	{
		timesError++;
		statusDivJS.innerHTML = "<span style='color:red;'><?php echo $language['error_connecting'] ?>("+timesError+"x)<\/span>";
	}
}
function failedResponse()
{
	if (!isInProgress) return;
	isInProgress = false;
	timesError++;
	statusDivJS.innerHTML = "<span style='color:red;'><?php echo $language['error_connecting'] ?>("+timesError+"x)(<a href='#' onClick='checkDomain();return false;'><?php echo $language['retry'] ?><\/a>)<\/span>";
	request.abort();
	request = null;
}
function retryRequest()
{
	if (!isInProgress) return;
	request.abort();
	isInProgress = false;
	request = null;
	statusDivJS.innerHTML = "<span style='color:red;'><?php echo $language['retrying'] ?><\/span>";
	checkDomain();
}
function abortRequest()
{
	if (!isInProgress) return;
	request.abort();
	isInProgress = false;
	request = null;
	statusDivJS.innerHTML = "<span style='color:red;'><?php echo $language['aborted'] ?><\/span>";
}
function updateDomainTld(tldBox)
{
	var domainText = domainInput.value;
	if (domainText.indexOf('.') == -1) return;
	domainText = domainText.substr(domainText,domainText.indexOf('.'));
	domainInput.value = domainText + "." + tldBox.value;
}
function processResponse()
{
	statusDivJS = document.getElementById("statusDiv");
	if (request.readyState == 4)
	{
		clearTimeout(intFailedResponse);
		var requestXML = request.responseXML;
		if ((requestXML != null) && (typeof(requestXML) == "object") && (requestXML.getElementsByTagName("domainname")[0] != null))
		{
			statusDivJS.innerHTML = "Done (<a href='#' onClick='checkDomain();return false;'><?php echo $language['force_recheck'] ?><\/a>)";
			isInProgress = false;
			var domain = requestXML.getElementsByTagName("domainname")[0].firstChild.data;
			var available = requestXML.getElementsByTagName("available")[0].firstChild.data;
			var errorMsg = "";
			if (requestXML.getElementsByTagName("errorMsg")[0].firstChild != null)
			{
				errorMsg = requestXML.getElementsByTagName("errorMsg")[0].firstChild.data;
				if (errorMsg.indexOf('Captcha') > -1)
				{
					Recaptcha.create("<?php echo RECAPTCHA_PUBLIC_KEY; ?>",
						"recaptcha_div", {
						   theme: "white",
						   callback: Recaptcha.focus_response_field
						});
					recaptcha_text.style.display="";
				}
			}
			if (available == "true")
			{
				statusDivJS.innerHTML = "<span class='green-domain'>"+requestXML.getElementsByTagName("message")[0].firstChild.data+"<\/span>";
				available = "<span style='color:green;'><b><?php echo $language['yes'] ?><\/b><\/span>	";
				if (showAvailableDomains)
				{
					if (domainsAvailableInput.value.indexOf(domain +" ") == -1)
						domainsAvailableInput.value = domainsAvailableInput.value + domain +" \n";
				}
			}
			else
			{
				statusDivJS.innerHTML = "'"+domain+"'<?php echo $language['Domain_not_Available'] ?>";
				<?php if ($enableWhoisChecking) { ?>
				statusDivJS.innerHTML +=  " <a href='?aj=&ws=&domain="+domain+"' target='_blank'><?php echo $language['do_whois']; ?><\/a>";
				<?php } ?>
				available = "<span style='color:red;'><?php echo $language['no'] ?><\/span>";
			}
			if (errorMsg != "")
			{
				statusDivJS.innerHTML = "<span style='color:red;'>"+errorMsg+"<\/span> [ <a href='#' onClick='checkDomain();return false;'><?php echo $language['retry'] ?><\/a> ]";
			}
			if (whatDomainDivJS != null)
				whatDomainDivJS.innerHTML = domain;
			if (isAvailableDivJS != null)
				isAvailableDivJS.innerHTML = available;
		}
		else
		{
			failedResponse();
			return;
		}
	}
	else if (request.readyState == 3)
	{
		statusDivJS.innerHTML = "<?php echo $language['request_sent'] ?>";
	}
}
function checkForChange()
{
	if (!isLoaded) return;
	if (domainInput == null) return;
	if (domainInput.value == '') return;
	if (prevCheckValue != (domainInput.value))
	{
		checkDomain();
	}
}
function bodyonLoad()
{
	statusDivJS = document.getElementById("statusDiv");
	isAvailableDivJS = document.getElementById("isAvailableDiv");
	domainInput =  document.getElementById("domain");
	domainsAvailableInput = document.getElementById("domainsAvailable");
	whatDomainDivJS = document.getElementById("whatDomainDiv");
	ajaxDomainForm =  document.getElementById("ajaxDomainForm");
	<?php if (ENABLE_RECAPTCHA) { ?>
	Recaptcha.create("<?php echo RECAPTCHA_PUBLIC_KEY; ?>",
		"recaptcha_div", {
		   theme: "white",
		   callback: Recaptcha.focus_response_field
		});
	 <?php } ?>
	 recaptcha_text = document.getElementById('recaptcha_text');
	isLoaded = true;
	<?php if ($enableAsYouType)
	{ ?>
		setInterval("checkForChange()",intervalToCheckForChange);
	<?php } ?>
}
window.onload = bodyonLoad;
</script>
<link rel="stylesheet" href="css/search.css" type="text/css" id="main-css">
<form class="form-wrapper" onSubmit="checkDomain();return false;" id="ajaxDomainForm" action="">
	<input name="domain" type="text" id="domain" placeholder="Domain Search" <?php if ($enableAsYouType) echo 'onKeyUp="checkForChange();"'; ?> maxlength="355" required>
	<button type="submit">Search</button>
	
<br>

	<br>
        <div id='statusDiv' style="font-family:Arial, Helvetica, sans-serif; font-weight:bold"><?php echo $language['type_a_domain'] ?><?php if (!$enableAsYouType) echo $language['and_press_enter'] ?></div>
</form>
