/********************************************

	-	THEMEPUNCH TOOLS Ver. 1.0     -

	 Last Update of Tools 28.03.2013

*********************************************/



/*!

 * jQuery Transit - CSS3 transitions and transformations

 * Copyright(c) 2011 Rico Sta. Cruz <rico@ricostacruz.com>

 * MIT Licensed.

 *

 * http://ricostacruz.com/jquery.transit

 * http://github.com/rstacruz/jquery.transit

 */



/*!

jQuery WaitForImages



Copyright (c) 2012 Alex Dickson



Permission is hereby granted, free of charge, to any person

obtaining a copy of this software and associated documentation

files (the "Software"), to deal in the Software without

restriction, including without limitation the rights to use,

copy, modify, merge, publish, distribute, sublicense, and/or sell

copies of the Software, and to permit persons to whom the

Software is furnished to do so, subject to the following

conditions:



The above copyright notice and this permission notice shall be

included in all copies or substantial portions of the Software.



THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,

EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES

OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND

NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT

HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,

WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING

FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR

OTHER DEALINGS IN THE SOFTWARE.





https://github.com/alexanderdickson/waitForImages





 */



// WAIT FOR IMAGES

/*

 * waitForImages 1.4

 * -----------------

 * Provides a callback when all images have loaded in your given selector.

 * http://www.alexanderdickson.com/

 *

 *

 * Copyright (c) 2011 Alex Dickson

 * Licensed under the MIT licenses.

 * See website for more info.

 *

 */



// EASINGS



/*!

 * jQuery Transit - CSS3 transitions and transformations

 * (c) 2011-2012 Rico Sta. Cruz <rico@ricostacruz.com>

 * MIT Licensed.

 *

 * http://ricostacruz.com/jquery.transit

 * http://github.com/rstacruz/jquery.transit

 */

(function(jQuery) {

  jQuery.transit = {

    version: "0.9.9",



    // Map of jQuery.css() keys to values for 'transitionProperty'.

    // See https://developer.mozilla.org/en/CSS/CSS_transitions#Properties_that_can_be_animated

    propertyMap: {

      marginLeft    : 'margin',

      marginRight   : 'margin',

      marginBottom  : 'margin',

      marginTop     : 'margin',

      paddingLeft   : 'padding',

      paddingRight  : 'padding',

      paddingBottom : 'padding',

      paddingTop    : 'padding'

    },



    // Will simply transition "instantly" if false

    enabled: true,



    // Set this to false if you don't want to use the transition end property.

    useTransitionEnd: false

  };



  var div = document.createElement('div');

  var support = {};



  // Helper function to get the proper vendor property name.

  // (`transition` => `WebkitTransition`)

  function getVendorPropertyName(prop) {

    // Handle unprefixed versions (FF16+, for example)

    if (prop in div.style) return prop;



    var prefixes = ['Moz', 'Webkit', 'O', 'ms'];

    var prop_ = prop.charAt(0).toUpperCase() + prop.substr(1);



    if (prop in div.style) { return prop; }



    for (var i=0; i<prefixes.length; ++i) {

      var vendorProp = prefixes[i] + prop_;

      if (vendorProp in div.style) { return vendorProp; }

    }

  }



  // Helper function to check if transform3D is supported.

  // Should return true for Webkits and Firefox 10+.

  function checkTransform3dSupport() {

    div.style[support.transform] = '';

    div.style[support.transform] = 'rotateY(90deg)';

    return div.style[support.transform] !== '';

  }



  var isChrome = navigator.userAgent.toLowerCase().indexOf('chrome') > -1;



  // Check for the browser's transitions support.

  support.transition      = getVendorPropertyName('transition');

  support.transitionDelay = getVendorPropertyName('transitionDelay');

  support.transform       = getVendorPropertyName('transform');

  support.transformOrigin = getVendorPropertyName('transformOrigin');

  support.transform3d     = checkTransform3dSupport();



  var eventNames = {

    'transition':       'transitionEnd',

    'MozTransition':    'transitionend',

    'OTransition':      'oTransitionEnd',

    'WebkitTransition': 'webkitTransitionEnd',

    'msTransition':     'MSTransitionEnd'

  };



  // Detect the 'transitionend' event needed.

  var transitionEnd = support.transitionEnd = eventNames[support.transition] || null;



  // Populate jQuery's `jQuery.support` with the vendor prefixes we know.

  // As per [jQuery's cssHooks documentation](http://api.jquery.com/jQuery.cssHooks/),

  // we set jQuery.support.transition to a string of the actual property name used.

  for (var key in support) {

    if (support.hasOwnProperty(key) && typeof jQuery.support[key] === 'undefined') {

      jQuery.support[key] = support[key];

    }

  }



  // Avoid memory leak in IE.

  div = null;



  // ## jQuery.cssEase

  // List of easing aliases that you can use with `jQuery.fn.transition`.

  jQuery.cssEase = {

    '_default':       'ease',

    'in':             'ease-in',

    'out':            'ease-out',

    'in-out':         'ease-in-out',

    'snap':           'cubic-bezier(0,1,.5,1)',

    // Penner equations

    'easeInCubic':    'cubic-bezier(.55, .055, .675, .19)',

    'easeOutCubic':   'cubic-bezier(.215,.61,.355,1)',

    'easeInOutCubic': 'cubic-bezier(.645,.045,.355,1)',

    'easeInCirc':     'cubic-bezier(.6,.04,.98,.335)',

    'easeOutCirc':    'cubic-bezier(.075,.82,.165,1)',

    'easeInOutCirc':  'cubic-bezier(.785,.135,.15,.86)',

    'easeInExpo':     'cubic-bezier(.95,.05,.795,.035)',

    'easeOutExpo':    'cubic-bezier(.19,1,.22,1)',

    'easeInOutExpo':  'cubic-bezier(1,0,0,1)',

    'easeInQuad':     'cubic-bezier(.55,.085,.68,.53)',

    'easeOutQuad':    'cubic-bezier(.25,.46,.45,.94)',

    'easeInOutQuad':  'cubic-bezier(.455,.03,.515,.955)',

    'easeInQuart':    'cubic-bezier(.895,.03,.685,.22)',

    'easeOutQuart':   'cubic-bezier(.165,.84,.44,1)',

    'easeInOutQuart': 'cubic-bezier(.77,0,.175,1)',

    'easeInQuint':    'cubic-bezier(.755,.05,.855,.06)',

    'easeOutQuint':   'cubic-bezier(.23,1,.32,1)',

    'easeInOutQuint': 'cubic-bezier(.86,0,.07,1)',

    'easeInSine':     'cubic-bezier(.47,0,.745,.715)',

    'easeOutSine':    'cubic-bezier(.39,.575,.565,1)',

    'easeInOutSine':  'cubic-bezier(.445,.05,.55,.95)',

    'easeInBack':     'cubic-bezier(.6,-.28,.735,.045)',

    'easeOutBack':    'cubic-bezier(.175, .885,.32,1.275)',

    'easeInOutBack':  'cubic-bezier(.68,-.55,.265,1.55)'

  };



  // ## 'transform' CSS hook

  // Allows you to use the `transform` property in CSS.

  //

  //     jQuery("#hello").css({ transform: "rotate(90deg)" });

  //

  //     jQuery("#hello").css('transform');

  //     //=> { rotate: '90deg' }

  //

  jQuery.cssHooks['transit:transform'] = {

    // The getter returns a `Transform` object.

    get: function(elem) {

      return jQuery(elem).data('transform') || new Transform();

    },



    // The setter accepts a `Transform` object or a string.

    set: function(elem, v) {

      var value = v;



      if (!(value instanceof Transform)) {

        value = new Transform(value);

      }



      // We've seen the 3D version of Scale() not work in Chrome when the

      // element being scaled extends outside of the viewport.  Thus, we're

      // forcing Chrome to not use the 3d transforms as well.  Not sure if

      // translate is affectede, but not risking it.  Detection code from

      // http://davidwalsh.name/detecting-google-chrome-javascript

      if (support.transform === 'WebkitTransform' && !isChrome) {

        elem.style[support.transform] = value.toString(true);

      } else {

        elem.style[support.transform] = value.toString();

      }



      jQuery(elem).data('transform', value);

    }

  };



  // Add a CSS hook for `.css({ transform: '...' })`.

  // In jQuery 1.8+, this will intentionally override the default `transform`

  // CSS hook so it'll play well with Transit. (see issue #62)

  jQuery.cssHooks.transform = {

    set: jQuery.cssHooks['transit:transform'].set

  };



  // jQuery 1.8+ supports prefix-free transitions, so these polyfills will not

  // be necessary.

  if (jQuery.fn.jquery < "1.8") {

    // ## 'transformOrigin' CSS hook

    // Allows the use for `transformOrigin` to define where scaling and rotation

    // is pivoted.

    //

    //     jQuery("#hello").css({ transformOrigin: '0 0' });

    //

    jQuery.cssHooks.transformOrigin = {

      get: function(elem) {

        return elem.style[support.transformOrigin];

      },

      set: function(elem, value) {

        elem.style[support.transformOrigin] = value;

      }

    };



    // ## 'transition' CSS hook

    // Allows you to use the `transition` property in CSS.

    //

    //     jQuery("#hello").css({ transition: 'all 0 ease 0' });

    //

    jQuery.cssHooks.transition = {

      get: function(elem) {

        return elem.style[support.transition];

      },

      set: function(elem, value) {

        elem.style[support.transition] = value;

      }

    };

  }



  // ## Other CSS hooks

  // Allows you to rotate, scale and translate.

  registerCssHook('scale');

  registerCssHook('translate');

  registerCssHook('rotate');

  registerCssHook('rotateX');

  registerCssHook('rotateY');

  registerCssHook('rotate3d');

  registerCssHook('perspective');

  registerCssHook('skewX');

  registerCssHook('skewY');

  registerCssHook('x', true);

  registerCssHook('y', true);



  // ## Transform class

  // This is the main class of a transformation property that powers

  // `jQuery.fn.css({ transform: '...' })`.

  //

  // This is, in essence, a dictionary object with key/values as `-transform`

  // properties.

  //

  //     var t = new Transform("rotate(90) scale(4)");

  //

  //     t.rotate             //=> "90deg"

  //     t.scale              //=> "4,4"

  //

  // Setters are accounted for.

  //

  //     t.set('rotate', 4)

  //     t.rotate             //=> "4deg"

  //

  // Convert it to a CSS string using the `toString()` and `toString(true)` (for WebKit)

  // functions.

  //

  //     t.toString()         //=> "rotate(90deg) scale(4,4)"

  //     t.toString(true)     //=> "rotate(90deg) scale3d(4,4,0)" (WebKit version)

  //

  function Transform(str) {

    if (typeof str === 'string') { this.parse(str); }

    return this;

  }



  Transform.prototype = {

    // ### setFromString()

    // Sets a property from a string.

    //

    //     t.setFromString('scale', '2,4');

    //     // Same as set('scale', '2', '4');

    //

    setFromString: function(prop, val) {

      var args =

        (typeof val === 'string')  ? val.split(',') :

        (val.constructor === Array) ? val :

        [ val ];



      args.unshift(prop);



      Transform.prototype.set.apply(this, args);

    },



    // ### set()

    // Sets a property.

    //

    //     t.set('scale', 2, 4);

    //

    set: function(prop) {

      var args = Array.prototype.slice.apply(arguments, [1]);

      if (this.setter[prop]) {

        this.setter[prop].apply(this, args);

      } else {

        this[prop] = args.join(',');

      }

    },



    get: function(prop) {

      if (this.getter[prop]) {

        return this.getter[prop].apply(this);

      } else {

        return this[prop] || 0;

      }

    },



    setter: {

      // ### rotate

      //

      //     .css({ rotate: 30 })

      //     .css({ rotate: "30" })

      //     .css({ rotate: "30deg" })

      //     .css({ rotate: "30deg" })

      //

      rotate: function(theta) {

        this.rotate = unit(theta, 'deg');

      },



      rotateX: function(theta) {

        this.rotateX = unit(theta, 'deg');

      },



      rotateY: function(theta) {

        this.rotateY = unit(theta, 'deg');

      },



      // ### scale

      //

      //     .css({ scale: 9 })      //=> "scale(9,9)"

      //     .css({ scale: '3,2' })  //=> "scale(3,2)"

      //

      scale: function(x, y) {

        if (y === undefined) { y = x; }

        this.scale = x + "," + y;

      },



      // ### skewX + skewY

      skewX: function(x) {

        this.skewX = unit(x, 'deg');

      },



      skewY: function(y) {

        this.skewY = unit(y, 'deg');

      },



      // ### perspectvie

      perspective: function(dist) {

        this.perspective = unit(dist, 'px');

      },



      // ### x / y

      // Translations. Notice how this keeps the other value.

      //

      //     .css({ x: 4 })       //=> "translate(4px, 0)"

      //     .css({ y: 10 })      //=> "translate(4px, 10px)"

      //

      x: function(x) {

        this.set('translate', x, null);

      },



      y: function(y) {

        this.set('translate', null, y);

      },



      // ### translate

      // Notice how this keeps the other value.

      //

      //     .css({ translate: '2, 5' })    //=> "translate(2px, 5px)"

      //

      translate: function(x, y) {

        if (this._translateX === undefined) { this._translateX = 0; }

        if (this._translateY === undefined) { this._translateY = 0; }



        if (x !== null && x !== undefined) { this._translateX = unit(x, 'px'); }

        if (y !== null && y !== undefined) { this._translateY = unit(y, 'px'); }



        this.translate = this._translateX + "," + this._translateY;

      }

    },



    getter: {

      x: function() {

        return this._translateX || 0;

      },



      y: function() {

        return this._translateY || 0;

      },



      scale: function() {

        var s = (this.scale || "1,1").split(',');

        if (s[0]) { s[0] = parseFloat(s[0]); }

        if (s[1]) { s[1] = parseFloat(s[1]); }



        // "2.5,2.5" => 2.5

        // "2.5,1" => [2.5,1]

        return (s[0] === s[1]) ? s[0] : s;

      },



      rotate3d: function() {

        var s = (this.rotate3d || "0,0,0,0deg").split(',');

        for (var i=0; i<=3; ++i) {

          if (s[i]) { s[i] = parseFloat(s[i]); }

        }

        if (s[3]) { s[3] = unit(s[3], 'deg'); }



        return s;

      }

    },



    // ### parse()

    // Parses from a string. Called on constructor.

    parse: function(str) {

      var self = this;

      str.replace(/([a-zA-Z0-9]+)\((.*?)\)/g, function(x, prop, val) {

        self.setFromString(prop, val);

      });

    },



    // ### toString()

    // Converts to a `transition` CSS property string. If `use3d` is given,

    // it converts to a `-webkit-transition` CSS property string instead.

    toString: function(use3d) {

      var re = [];



      for (var i in this) {

        if (this.hasOwnProperty(i)) {

          // Don't use 3D transformations if the browser can't support it.

          if ((!support.transform3d) && (

            (i === 'rotateX') ||

            (i === 'rotateY') ||

            (i === 'perspective') ||

            (i === 'transformOrigin'))) { continue; }



          if (i[0] !== '_') {

            if (use3d && (i === 'scale')) {

              re.push(i + "3d(" + this[i] + ",1)");

            } else if (use3d && (i === 'translate')) {

              re.push(i + "3d(" + this[i] + ",0)");

            } else {

              re.push(i + "(" + this[i] + ")");

            }

          }

        }

      }



      return re.join(" ");

    }

  };



  function callOrQueue(self, queue, fn) {

    if (queue === true) {

      self.queue(fn);

    } else if (queue) {

      self.queue(queue, fn);

    } else {

      fn();

    }

  }



  // ### getProperties(dict)

  // Returns properties (for `transition-property`) for dictionary `props`. The

  // value of `props` is what you would expect in `jQuery.css(...)`.

  function getProperties(props) {

    var re = [];



    jQuery.each(props, function(key) {

      key = jQuery.camelCase(key); // Convert "text-align" => "textAlign"

      key = jQuery.transit.propertyMap[key] || jQuery.cssProps[key] || key;

      key = uncamel(key); // Convert back to dasherized



      if (jQuery.inArray(key, re) === -1) { re.push(key); }

    });



    return re;

  }



  // ### getTransition()

  // Returns the transition string to be used for the `transition` CSS property.

  //

  // Example:

  //

  //     getTransition({ opacity: 1, rotate: 30 }, 500, 'ease');

  //     //=> 'opacity 500ms ease, -webkit-transform 500ms ease'

  //

  function getTransition(properties, duration, easing, delay) {

    // Get the CSS properties needed.

    var props = getProperties(properties);



    // Account for aliases (`in` => `ease-in`).

    if (jQuery.cssEase[easing]) { easing = jQuery.cssEase[easing]; }



    // Build the duration/easing/delay attributes for it.

    var attribs = '' + toMS(duration) + ' ' + easing;

    if (parseInt(delay, 10) > 0) { attribs += ' ' + toMS(delay); }



    // For more properties, add them this way:

    // "margin 200ms ease, padding 200ms ease, ..."

    var transitions = [];

    jQuery.each(props, function(i, name) {

      transitions.push(name + ' ' + attribs);

    });



    return transitions.join(', ');

  }



  // ## jQuery.fn.transition

  // Works like jQuery.fn.animate(), but uses CSS transitions.

  //

  //     jQuery("...").transition({ opacity: 0.1, scale: 0.3 });

  //

  //     // Specific duration

  //     jQuery("...").transition({ opacity: 0.1, scale: 0.3 }, 500);

  //

  //     // With duration and easing

  //     jQuery("...").transition({ opacity: 0.1, scale: 0.3 }, 500, 'in');

  //

  //     // With callback

  //     jQuery("...").transition({ opacity: 0.1, scale: 0.3 }, function() { ... });

  //

  //     // With everything

  //     jQuery("...").transition({ opacity: 0.1, scale: 0.3 }, 500, 'in', function() { ... });

  //

  //     // Alternate syntax

  //     jQuery("...").transition({

  //       opacity: 0.1,

  //       duration: 200,

  //       delay: 40,

  //       easing: 'in',

  //       complete: function() { /* ... */ }

  //      });

  //

  jQuery.fn.transition = jQuery.fn.transit = function(properties, duration, easing, callback) {

    var self  = this;

    var delay = 0;

    var queue = true;



    var theseProperties = jQuery.extend(true, {}, properties);



    // Account for `.transition(properties, callback)`.

    if (typeof duration === 'function') {

      callback = duration;

      duration = undefined;

    }



    // Account for `.transition(properties, options)`.

    if (typeof duration === 'object') {

      easing = duration.easing;

      delay = duration.delay || 0;

      queue = duration.queue || true;

      callback = duration.complete;

      duration = duration.duration;

    }



    // Account for `.transition(properties, duration, callback)`.

    if (typeof easing === 'function') {

      callback = easing;

      easing = undefined;

    }



    // Alternate syntax.

    if (typeof theseProperties.easing !== 'undefined') {

      easing = theseProperties.easing;

      delete theseProperties.easing;

    }



    if (typeof theseProperties.duration !== 'undefined') {

      duration = theseProperties.duration;

      delete theseProperties.duration;

    }



    if (typeof theseProperties.complete !== 'undefined') {

      callback = theseProperties.complete;

      delete theseProperties.complete;

    }



    if (typeof theseProperties.queue !== 'undefined') {

      queue = theseProperties.queue;

      delete theseProperties.queue;

    }



    if (typeof theseProperties.delay !== 'undefined') {

      delay = theseProperties.delay;

      delete theseProperties.delay;

    }



    // Set defaults. (`400` duration, `ease` easing)

    if (typeof duration === 'undefined') { duration = jQuery.fx.speeds._default; }

    if (typeof easing === 'undefined')   { easing = jQuery.cssEase._default; }



    duration = toMS(duration);



    // Build the `transition` property.

    var transitionValue = getTransition(theseProperties, duration, easing, delay);



    // Compute delay until callback.

    // If this becomes 0, don't bother setting the transition property.

    var work = jQuery.transit.enabled && support.transition;

    var i = work ? (parseInt(duration, 10) + parseInt(delay, 10)) : 0;



    // If there's nothing to do...

    if (i === 0) {

      var fn = function(next) {

        self.css(theseProperties);

        if (callback) { callback.apply(self); }

        if (next) { next(); }

      };



      callOrQueue(self, queue, fn);

      return self;

    }



    // Save the old transitions of each element so we can restore it later.

    var oldTransitions = {};



    var run = function(nextCall) {

      var bound = false;



      // Prepare the callback.

      var cb = function() {

        if (bound) { self.unbind(transitionEnd, cb); }



        if (i > 0) {

          self.each(function() {

            this.style[support.transition] = (oldTransitions[this] || null);

          });

        }



        if (typeof callback === 'function') { callback.apply(self); }

        if (typeof nextCall === 'function') { nextCall(); }

      };



      if ((i > 0) && (transitionEnd) && (jQuery.transit.useTransitionEnd)) {

        // Use the 'transitionend' event if it's available.

        bound = true;

        self.bind(transitionEnd, cb);

      } else {

        // Fallback to timers if the 'transitionend' event isn't supported.

        window.setTimeout(cb, i);

      }



      // Apply transitions.

      self.each(function() {

        if (i > 0) {

          this.style[support.transition] = transitionValue;

        }

        jQuery(this).css(properties);

      });

    };



    // Defer running. This allows the browser to paint any pending CSS it hasn't

    // painted yet before doing the transitions.

    var deferredRun = function(next) {

        this.offsetWidth; // force a repaint

        run(next);

    };



    // Use jQuery's fx queue.

    callOrQueue(self, queue, deferredRun);



    // Chainability.

    return this;

  };



  function registerCssHook(prop, isPixels) {

    // For certain properties, the 'px' should not be implied.

    if (!isPixels) { jQuery.cssNumber[prop] = true; }



    jQuery.transit.propertyMap[prop] = support.transform;



    jQuery.cssHooks[prop] = {

      get: function(elem) {

        var t = jQuery(elem).css('transit:transform');

        return t.get(prop);

      },



      set: function(elem, value) {

        var t = jQuery(elem).css('transit:transform');

        t.setFromString(prop, value);



        jQuery(elem).css({ 'transit:transform': t });

      }

    };



  }



  // ### uncamel(str)

  // Converts a camelcase string to a dasherized string.

  // (`marginLeft` => `margin-left`)

  function uncamel(str) {

    return str.replace(/([A-Z])/g, function(letter) { return '-' + letter.toLowerCase(); });

  }



  // ### unit(number, unit)

  // Ensures that number `number` has a unit. If no unit is found, assume the

  // default is `unit`.

  //

  //     unit(2, 'px')          //=> "2px"

  //     unit("30deg", 'rad')   //=> "30deg"

  //

  function unit(i, units) {

    if ((typeof i === "string") && (!i.match(/^[\-0-9\.]+$/))) {

      return i;

    } else {

      return "" + i + units;

    }

  }



  // ### toMS(duration)

  // Converts given `duration` to a millisecond string.

  //

  // toMS('fast') => jQuery.fx.speeds[i] => "200ms"

  // toMS('normal') //=> jQuery.fx.speeds._default => "400ms"

  // toMS(10) //=> '10ms'

  // toMS('100ms') //=> '100ms'

  //

  function toMS(duration) {

    var i = duration;



    // Allow string durations like 'fast' and 'slow', without overriding numeric values.

    if (typeof i === 'string' && (!i.match(/^[\-0-9\.]+/))) { i = jQuery.fx.speeds[i] || jQuery.fx.speeds._default; }



    return unit(i, 'ms');

  }



  // Export some functions for testable-ness.

  jQuery.transit.getTransitionValue = getTransition;

})(jQuery);



(function(e,t){

	jQuery.easing["jswing"]=jQuery.easing["swing"];

	jQuery.extend(jQuery.easing,{def:"easeOutQuad",swing:function(e,t,n,r,i){return jQuery.easing[jQuery.easing.def](e,t,n,r,i)},easeInQuad:function(e,t,n,r,i){return r*(t/=i)*t+n},easeOutQuad:function(e,t,n,r,i){return-r*(t/=i)*(t-2)+n},easeInOutQuad:function(e,t,n,r,i){if((t/=i/2)<1)return r/2*t*t+n;return-r/2*(--t*(t-2)-1)+n},easeInCubic:function(e,t,n,r,i){return r*(t/=i)*t*t+n},easeOutCubic:function(e,t,n,r,i){return r*((t=t/i-1)*t*t+1)+n},easeInOutCubic:function(e,t,n,r,i){if((t/=i/2)<1)return r/2*t*t*t+n;return r/2*((t-=2)*t*t+2)+n},easeInQuart:function(e,t,n,r,i){return r*(t/=i)*t*t*t+n},easeOutQuart:function(e,t,n,r,i){return-r*((t=t/i-1)*t*t*t-1)+n},easeInOutQuart:function(e,t,n,r,i){if((t/=i/2)<1)return r/2*t*t*t*t+n;return-r/2*((t-=2)*t*t*t-2)+n},easeInQuint:function(e,t,n,r,i){return r*(t/=i)*t*t*t*t+n},easeOutQuint:function(e,t,n,r,i){return r*((t=t/i-1)*t*t*t*t+1)+n},easeInOutQuint:function(e,t,n,r,i){if((t/=i/2)<1)return r/2*t*t*t*t*t+n;return r/2*((t-=2)*t*t*t*t+2)+n},easeInSine:function(e,t,n,r,i){return-r*Math.cos(t/i*(Math.PI/2))+r+n},easeOutSine:function(e,t,n,r,i){return r*Math.sin(t/i*(Math.PI/2))+n},easeInOutSine:function(e,t,n,r,i){return-r/2*(Math.cos(Math.PI*t/i)-1)+n},easeInExpo:function(e,t,n,r,i){return t==0?n:r*Math.pow(2,10*(t/i-1))+n},easeOutExpo:function(e,t,n,r,i){return t==i?n+r:r*(-Math.pow(2,-10*t/i)+1)+n},easeInOutExpo:function(e,t,n,r,i){if(t==0)return n;if(t==i)return n+r;if((t/=i/2)<1)return r/2*Math.pow(2,10*(t-1))+n;return r/2*(-Math.pow(2,-10*--t)+2)+n},easeInCirc:function(e,t,n,r,i){return-r*(Math.sqrt(1-(t/=i)*t)-1)+n},easeOutCirc:function(e,t,n,r,i){return r*Math.sqrt(1-(t=t/i-1)*t)+n},easeInOutCirc:function(e,t,n,r,i){if((t/=i/2)<1)return-r/2*(Math.sqrt(1-t*t)-1)+n;return r/2*(Math.sqrt(1-(t-=2)*t)+1)+n},easeInElastic:function(e,t,n,r,i){var s=1.70158;var o=0;var u=r;if(t==0)return n;if((t/=i)==1)return n+r;if(!o)o=i*.3;if(u<Math.abs(r)){u=r;var s=o/4}else var s=o/(2*Math.PI)*Math.asin(r/u);return-(u*Math.pow(2,10*(t-=1))*Math.sin((t*i-s)*2*Math.PI/o))+n},easeOutElastic:function(e,t,n,r,i){var s=1.70158;var o=0;var u=r;if(t==0)return n;if((t/=i)==1)return n+r;if(!o)o=i*.3;if(u<Math.abs(r)){u=r;var s=o/4}else var s=o/(2*Math.PI)*Math.asin(r/u);return u*Math.pow(2,-10*t)*Math.sin((t*i-s)*2*Math.PI/o)+r+n},easeInOutElastic:function(e,t,n,r,i){var s=1.70158;var o=0;var u=r;if(t==0)return n;if((t/=i/2)==2)return n+r;if(!o)o=i*.3*1.5;if(u<Math.abs(r)){u=r;var s=o/4}else var s=o/(2*Math.PI)*Math.asin(r/u);if(t<1)return-.5*u*Math.pow(2,10*(t-=1))*Math.sin((t*i-s)*2*Math.PI/o)+n;return u*Math.pow(2,-10*(t-=1))*Math.sin((t*i-s)*2*Math.PI/o)*.5+r+n},easeInBack:function(e,t,n,r,i,s){if(s==undefined)s=1.70158;return r*(t/=i)*t*((s+1)*t-s)+n},easeOutBack:function(e,t,n,r,i,s){if(s==undefined)s=1.70158;return r*((t=t/i-1)*t*((s+1)*t+s)+1)+n},easeInOutBack:function(e,t,n,r,i,s){if(s==undefined)s=1.70158;if((t/=i/2)<1)return r/2*t*t*(((s*=1.525)+1)*t-s)+n;return r/2*((t-=2)*t*(((s*=1.525)+1)*t+s)+2)+n},easeInBounce:function(e,t,n,r,i){return r-jQuery.easing.easeOutBounce(e,i-t,0,r,i)+n},easeOutBounce:function(e,t,n,r,i){if((t/=i)<1/2.75){return r*7.5625*t*t+n}else if(t<2/2.75){return r*(7.5625*(t-=1.5/2.75)*t+.75)+n}else if(t<2.5/2.75){return r*(7.5625*(t-=2.25/2.75)*t+.9375)+n}else{return r*(7.5625*(t-=2.625/2.75)*t+.984375)+n}},easeInOutBounce:function(e,t,n,r,i){if(t<i/2)return jQuery.easing.easeInBounce(e,t*2,0,r,i)*.5+n;return jQuery.easing.easeOutBounce(e,t*2-i,0,r,i)*.5+r*.5+n}});

					e.waitForImages={hasImageProperties:["backgroundImage","listStyleImage","borderImage","borderCornerImage"]};e.expr[":"].uncached=function(t){var n=document.createElement("img");n.src=t.src;return e(t).is('img[src!=""]')&&!n.complete};e.fn.waitForImages=function(t,n,r){if(e.isPlainObject(arguments[0])){n=t.each;r=t.waitForAll;t=t.finished}t=t||e.noop;n=n||e.noop;r=!!r;if(!e.isFunction(t)||!e.isFunction(n)){throw new TypeError("An invalid callback was supplied.")}return this.each(function(){var i=e(this),s=[];if(r){var o=e.waitForImages.hasImageProperties||[],u=/url\((['"]?)(.*?)\1\)/g;i.find("*").each(function(){var t=e(this);if(t.is("img:uncached")){s.push({src:t.attr("src"),element:t[0]})}e.each(o,function(e,n){var r=t.css(n);if(!r){return true}var i;while(i=u.exec(r)){s.push({src:i[2],element:t[0]})}})})}else{i.find("img:uncached").each(function(){s.push({src:this.src,element:this})})}var f=s.length,l=0;if(f==0){t.call(i[0])}e.each(s,function(r,s){var o=new Image;e(o).bind("load error",function(e){l++;n.call(s.element,l,f,e.type=="load");if(l==f){t.call(i[0]);return false}});o.src=s.src})})};

					e.fn.swipe=function(t){if(!this)return false;var n={fingers:1,threshold:75,swipe:null,swipeLeft:null,swipeRight:null,swipeUp:null,swipeDown:null,swipeStatus:null,click:null,triggerOnTouchEnd:true,allowPageScroll:"auto"};var r="left";var i="right";var s="up";var o="down";var u="none";var f="horizontal";var l="vertical";var c="auto";var h="start";var p="move";var d="end";var v="cancel";var m="ontouchstart"in window,g=m?"touchstart":"mousedown",y=m?"touchmove":"mousemove",b=m?"touchend":"mouseup",w="touchcancel";var E="start";if(t.allowPageScroll==undefined&&(t.swipe!=undefined||t.swipeStatus!=undefined))t.allowPageScroll=u;if(t)e.extend(n,t);return this.each(function(){function t(){var e=S();if(e<=45&&e>=0)return r;else if(e<=360&&e>=315)return r;else if(e>=135&&e<=225)return i;else if(e>45&&e<135)return o;else return s}function S(){var e=H.x-B.x;var t=B.y-H.y;var n=Math.atan2(t,e);var r=Math.round(n*180/Math.PI);if(r<0)r=360-Math.abs(r);return r}function x(){return Math.round(Math.sqrt(Math.pow(B.x-H.x,2)+Math.pow(B.y-H.y,2)))}function T(e,t){if(n.allowPageScroll==u){e.preventDefault()}else{var a=n.allowPageScroll==c;switch(t){case r:if(n.swipeLeft&&a||!a&&n.allowPageScroll!=f)e.preventDefault();break;case i:if(n.swipeRight&&a||!a&&n.allowPageScroll!=f)e.preventDefault();break;case s:if(n.swipeUp&&a||!a&&n.allowPageScroll!=l)e.preventDefault();break;case o:if(n.swipeDown&&a||!a&&n.allowPageScroll!=l)e.preventDefault();break}}}function N(e,t){if(n.swipeStatus)n.swipeStatus.call(_,e,t,direction||null,distance||0);if(t==v){if(n.click&&(P==1||!m)&&(isNaN(distance)||distance==0))n.click.call(_,e,e.target)}if(t==d){if(n.swipe){n.swipe.call(_,e,direction,distance)}switch(direction){case r:if(n.swipeLeft)n.swipeLeft.call(_,e,direction,distance);break;case i:if(n.swipeRight)n.swipeRight.call(_,e,direction,distance);break;case s:if(n.swipeUp)n.swipeUp.call(_,e,direction,distance);break;case o:if(n.swipeDown)n.swipeDown.call(_,e,direction,distance);break}}}function C(e){P=0;H.x=0;H.y=0;B.x=0;B.y=0;F.x=0;F.y=0}function L(e){e.preventDefault();distance=x();direction=t();if(n.triggerOnTouchEnd){E=d;if((P==n.fingers||!m)&&B.x!=0){if(distance>=n.threshold){N(e,E);C(e)}else{E=v;N(e,E);C(e)}}else{E=v;N(e,E);C(e)}}else if(E==p){E=v;N(e,E);C(e)}M.removeEventListener(y,A,false);M.removeEventListener(b,L,false)}function A(e){if(E==d||E==v)return;var r=m?e.touches[0]:e;B.x=r.pageX;B.y=r.pageY;direction=t();if(m){P=e.touches.length}E=p;T(e,direction);if(P==n.fingers||!m){distance=x();if(n.swipeStatus)N(e,E,direction,distance);if(!n.triggerOnTouchEnd){if(distance>=n.threshold){E=d;N(e,E);C(e)}}}else{E=v;N(e,E);C(e)}}function O(e){var t=m?e.touches[0]:e;E=h;if(m){P=e.touches.length}distance=0;direction=null;if(P==n.fingers||!m){H.x=B.x=t.pageX;H.y=B.y=t.pageY;if(n.swipeStatus)N(e,E)}else{C(e)}M.addEventListener(y,A,false);M.addEventListener(b,L,false)}var M=this;var _=e(this);var D=null;var P=0;var H={x:0,y:0};var B={x:0,y:0};var F={x:0,y:0};try{this.addEventListener(g,O,false);this.addEventListener(w,C)}catch(I){}})}

	})(jQuery)



// SOME ERROR MESSAGES IN CASE THE PLUGIN CAN NOT BE LOADED

function revslider_showDoubleJqueryError(sliderID) {

	var errorMessage = "Revolution Slider Error: You have some jquery.js library include that comes after the revolution files js include.";

	errorMessage += "<br> This includes make eliminates the revolution slider libraries, and make it not work.";

	errorMessage += "<br><br> To fix it you can:<br>&nbsp;&nbsp;&nbsp; 1. In the Slider Settings -> Troubleshooting set option:  <strong><b>Put JS Includes To Body</b></strong> option to true.";

	errorMessage += "<br>&nbsp;&nbsp;&nbsp; 2. Find the double jquery.js include and remove it.";

	errorMessage = "<span style='font-size:16px;color:#BC0C06;'>" + errorMessage + "</span>"

		jQuery(sliderID).show().html(errorMessage);

}

