<?php
 $pageTitle='security FAQ - StarHOST';
?>
<?php include 'header_assets.php'; ?>
<body>
<div class="main_menu_mobile">
  <?php include 'main_menu.php'; ?>
</div>
<!-- Start Switcher --> 

<!-- End Switcher -->

<?php include 'header.php'; ?>

<!-- Main Menu -->
<div class="main_menu">
  <?php include 'main_menu.php'; ?>
</div>
<!-- End of Main Menu --> 

<!-- Page Header -->
<section class="section_sapce section_primary cover-image" data-image-src="images/info-banners/faq-banner.jpg">
  <div class="section-title ">
    <h2><span>FAQ's</span>Security</h2>
  </div>
</section>
<!--  Page Header --> 


<!-- End of Pricing Tables --> 

<section class="section_sapce white">

    <div class="container">
      <div class="col-md-12 accordion-wrapper" id="the-accordion">
       <div class="accordion-panel">
  <div class="accordion-title"><a href="#">Is  my website secure?</a></div>
  <div class="accordion-content">Probably not.<br>
  Unless you have actively thought  about your sites security (or are using a managed hosting provider that thinks  about it for you), you likely have at least a few potential security holes.<br>
  Here are a handful of basic security  precautions you should be taking with any website:
<ul type="disc">
  <li>Use a strong password for your hosting account, FTP       accounts, email accounts, and any other accounts associated with your       website.</li>
  <li>Do not use the same password for all your different       accounts.</li>
  <li>Do not email your password or store it in plain text       anywhere.</li>
  <li>Restrict FTP and SSH access to your IP address.</li>
  <li>Enable two-factor authentication on your hosting plan       and your domain name registrar.</li>
  <li>Keep all of your software and plugins up to date.</li>
  <li>Back up your data regularly.</li>
  <li>Use a CDN that provides DDOS protection.</li>
  <li>Enable HTTPS on your site by getting an SSL       certificate.</li>
</ul>
<p>Since WordPress is the most popular  content management system, here some WordPress-specific security tips:</p>
<ul type="disc">
  <li>Do not use the default &quot;admin&quot; as your       administrator user name</li>
  <li>Install the <u>Bad Behavior</u> and <u>Akismet</u> plugins to combat spam</li>
  <li>change your user nickname, so that your login name       isn't publicly visible in posts and URLs</li>
  <li>Limit login attempts</li>
</ul></div></div>

<div class="accordion-panel">
  <div class="accordion-title"><a href="#">How  to protect customer data on website?</a></div>
<div class="accordion-content"><ul type="disc">
  <li>Use mature, Open Source software</li>
  <li>Install an SSL security certificate</li>
  <li>Force HTTPS for all connections (this requires a       security certificate)</li>
  <li>Use trusted payment processors</li>
  <li>Follow all of the security precautions listed above.</li>
</ul></div></div>
<div class="accordion-panel">
  <div class="accordion-title"><a href="#">What  is a security certificate?</a></div>
  <div class="accordion-content">To understand a security  certificate, you first have to understand Public Key encryption.<br>
  Public Key encryption works like  this: there are two &quot;keys&quot; — a key is a very long string of seemingly  random data that is used as a value in an encryption formula. One key is  Private, known only to one party (in this case, the website owner). The private  key has a &quot;matching&quot; Public key, which is published and available for  anyone to use.<br>
  A message can be encrypted using the  Public Key, and it can only be decrypted with the Private Key. This way you can  send sensitive data securly, and only the one who is supposed to get it will be  able to decrypt it.<br>
  The other interesting thing is that  you can encrypt data with the Private key, and only the Public key will be able  to decrypt it. This may seem meaningless — if the Public key is Public, then  anyone can read the message. That's true, but this accomplishes something more  important: it verifies that the message was in fact sent by the party who who  says they sent it — only the owner of the Private Key could encrypt the data  this way. (This is called &quot;signing.&quot;)<br>
  When you use HTTPS, you are  communicating with a website via a series of encrypted messages. Your messages  are sent encrypted via the Public Key (ensuring only the website gets your  data) and responses from the web server are sent signed by the Private Key  (ensuring that they are authentic).<br>
  So what does the SSL certificate  have to do with this?<br>
  Once you are certain that the Public  Key you are using belongs to the website that you are visiting, and that the  website is trustworthy, the rest of the process is secure. But the Public Key  doesn't guarantee identity by itself — a malicious agent could create a fake  Public Key and send it to site visitors, and intercept data between site and  visitor.<br>
  You need some way of verifying that  the Public Key is the right one, that it authentically identifies the correct  party.<br>
  This is what an SSL Certificate does  — it certifies the identity of the Public Key.<br></div></div>

  <div class="accordion-panel">
  <div class="accordion-title"><a href="#">How  to get a security certificate?</a></div>
  <div class="accordion-content">You buy one from an SSL certificate  provider. Most hosting companies partner with an SSL certificate vendor, and  make it easy to buy one as an account upgrade.<br></div></div>

  <div class="accordion-panel">
  <div class="accordion-title"><a href="#">Can  I use SSL certificate on shared hosting?</a></div>
  <div class="accordion-content">Yes, but you will need a Dedicate IP  address.<br></div></div>

  <div class="accordion-panel">
  <div class="accordion-title"><a href="#">Do  I need SSL?</a></div>
  <div class="accordion-content">You need an SSL certificate if you  are handling any sensitive customer data. Ecommerce sites, hich usually handle  credit card payments, definitely need an SSL certificate. A site that allows  for personal or private communication — email, messaging, file storage — needs  a certificate.<br>
  Even if you don't have a specific  requirement for an SSL security certificate, you may want to get one anyway. A  number of organizations have recognized that HTTPS promotes safer browsing  generally. Google agrees with this, and actually provides an SEO benefit to  sites that use HTTPS as an incentive to encourage more sites to adopt it.<br></div></div>
  
  <div class="accordion-panel">
  <div class="accordion-title"><a href="#">What  is HTTPS?</a></div>
  <div class="accordion-content">HTTPS is <em>secure</em> HTTP. It is  the protocol used when communicating with a website over SSL.<br></div></div>
  <div class="accordion-panel">
  <div class="accordion-title"><a href="#">Why  do I get an error with HTTPS?</a></div>
  <div class="accordion-content">If visitors to your site are getting  an error when they try to use HTTPS, it is likely a problem with your SSL  certificate. Make sure you have one, that it is up to date, and that it is  installed properly.<br></div></div>
  <div class="accordion-panel">
  <div class="accordion-title"><a href="#">What  security is needed for credit card transactions?</a></div>
  <div class="accordion-content">Credit Card transactions should  always be run over SSL (HTTPS). Credit card numbers should only be stored in a  highly secure, encrypted datastore (which usually means — not the application  you are building currently, but with a mature, well-regarded payment  processor).</p></div></div>


      </div>            
    </div>
  </section>


<?php include 'subscribe.php'; ?>

<!--  Footer -->
<footer class="footer">
  <?php include 'footer.php'; ?>
</footer>
<!--  End of Footer --> 

<!--  Scripts --> 
<!--  Back to Top -->
<style type="">
  .main-feature{height: 380px;}
</style>
<?php include 'footer_assets.php'; ?>